

/* Pocket Smalltalk
   Copyright (c) 1998,1999 by Andrew Brault
   http://www.pocketsmalltalk.com
   See LICENSE.TXT for license information */

/* This header file needs to be included by all
   the C source files. */

#include <PalmOS.h>
#include <PalmCompatibility.h>

/* Compilation options: */

/* Interpret debugging info present in the image file */
#define DEBUG_INFO

/* Collect profiling information during execution */
/* #define PROFILING */

/* Use POSER to collect profiling information on the interpret loop */
// #define POSER_PROFILING

/* Stress test -- runs ultra slow but picks up many bugs */
// #define STRESS

/* Various runtime assertions, moderate slowdawn. */
// #define SAFETY

/* Check for some "can't happen" situations */
// #define PARANOIA

/* Use a global method cache to speed up lookups */
#define METHOD_CACHE

/* Use optimized StringWriteStream primitives */
#define OPTIMIZED_STRING_STREAMS

/* Compile microcode for some Java support instructions */
/* #define JAVA_INSTRUCTIONS */

/* Support for floating point numbers via MathLib */
// #define USE_MATHLIB
// #undef USE_MATHLIB

/* Greyscale graphics support (not yet implemented) */
// #define GREYSCALE



#ifndef TRUE
#define TRUE  1
#define FALSE 0
#endif

/* This is "C nil" (null pointer) not Smalltalk nil. */
#define NIL  0


typedef unsigned char uint8;
typedef signed int int16;
typedef signed long int32;
typedef unsigned int uint16;
typedef unsigned long uint32;
typedef unsigned int Value;
typedef int boolean;

#include "memory.h"
#include "vm.h"
#include "prim.h"
#include "math.h"

#ifdef USE_MATHLIB
#include "MathLib.h"
#endif

/*
#ifdef POSER_PROFILING
#include "HostControl.h"
#endif
*/

/* Functions in main.c */
void panic(char * message);
